//SPECTRUM OF SIGNAL (FREQUENCY RESPONSE)- BLACKMANN WINDOW
//OS:Windows 10
//Scilab 5.5.2

clear all;
clc;
close;

//With maximum normalized frequency f = 0.4

N = 11;
cfreq = [0.4 0];
[wft,wfm,fr]=wfir('lp',N,cfreq,'re',0);
wft;                // Time domain filter coefficients
wfm;                // Frequency domain filter values
fr;                 // Frequency sample points
for n = 1:N
  h_blackmann(n)=0.42-0.5*cos(2*%pi*n/(N-1))+0.08*cos(4*%pi*n/(N-1));
  wft_blmn(n) = wft(n)*h_blackmann(n);
end
wfm_blmn = frmag(wft_blmn,length(fr));
WFM_blmn_dB =20*log10(wfm_blmn);
plot2d(fr,WFM_blmn_dB)
xtitle('Frequency Response of Blackmann window Filtered output N = 11','Frequency in cycles per samples  f','Energy density in dB')
